<?php
/* --------------------------------------------------------------
   FetchSpecificWithdrawalAction.php 2020-04-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Api\Withdrawal\Actions;

use Gambio\Admin\Withdrawal\Exceptions\WithdrawalNotFoundException;
use Gambio\Admin\Withdrawal\Interfaces\WithdrawalService;
use Gambio\Admin\Withdrawal\Models\WithdrawalId;
use Gambio\Api\Application\Responses\CreateApiMetaDataTrait;
use Slim\Http\Response;
use Slim\Http\ServerRequest as Request;

/**
 * Class FetchSpecificWithdrawalAction
 *
 * @package Gambio\Api\Withdrawal\Actions
 */
class FetchSpecificWithdrawalAction
{
    use CreateApiMetaDataTrait;
    
    /**
     * @var WithdrawalService
     */
    private $service;
    
    
    /**
     * FetchSpecificWithdrawalAction constructor.
     *
     * @param WithdrawalService $service
     */
    public function __construct(WithdrawalService $service)
    {
        $this->service = $service;
    }
    
    
    /**
     * @param Request  $request
     * @param Response $response
     * @param array    $args
     *
     * @return Response
     */
    public function __invoke(Request $request, Response $response, array $args): Response
    {
        try {
            $withdrawalId = WithdrawalId::create((int)$request->getAttribute('id'));
            $withdrawal   = $this->service->getWithdrawalById($withdrawalId);
            $metaData     = $this->createApiMetaData();
            
            return $response->withJson([
                                           'data'  => $withdrawal,
                                           '_meta' => $metaData,
                                       ]);
        } catch (WithdrawalNotFoundException $e) {
            return $response->withStatus(404);
        }
    }
}